/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.category.rule;

import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import xaero.common.category.rule.ExcludeListMode;
import xaero.common.category.rule.ObjectCategoryListRule;
import xaero.common.misc.ListFactory;

public final class ObjectCategoryExcludeList<E, S>
extends ObjectCategoryListRule<E, S> {
    private ExcludeListMode excludeMode;

    private ObjectCategoryExcludeList(@Nonnull List<String> stringList, @Nonnull List<S> list, @Nonnull ExcludeListMode excludeMode, @Nonnull Function<E, S> getter, @Nonnull Comparator<S> comparator, @Nonnull Predicate<String> stringValidator) {
        super("exclude list", stringList, list, getter, comparator, stringValidator);
        this.excludeMode = excludeMode;
    }

    @Override
    public boolean isFollowedBy(E object, Object context) {
        boolean inList = this.inList((Object)object);
        return this.excludeMode == ExcludeListMode.ALL_BUT && inList || this.excludeMode == ExcludeListMode.ONLY && !inList;
    }

    public ExcludeListMode getExcludeMode() {
        return this.excludeMode;
    }

    public static final class Builder<E, S>
    extends ObjectCategoryListRule.Builder<E, S, Builder<E, S>> {
        private ExcludeListMode excludeMode;

        public Builder(ListFactory listFactory) {
            super(listFactory);
        }

        @Override
        public Builder<E, S> setDefault() {
            this.setExcludeMode(ExcludeListMode.ONLY);
            return (Builder)super.setDefault();
        }

        public void setExcludeMode(ExcludeListMode excludeMode) {
            this.excludeMode = excludeMode;
        }

        @Override
        public ObjectCategoryExcludeList<E, S> build() {
            return (ObjectCategoryExcludeList)super.build();
        }

        @Override
        protected ObjectCategoryExcludeList<E, S> buildInternally(List<S> effectiveList) {
            return new ObjectCategoryExcludeList(this.stringList, effectiveList, this.excludeMode, this.getter, this.comparator, (Predicate<String>)this.stringValidator);
        }

        public static <E, P, S> Builder<E, S> getDefault(ListFactory listFactory) {
            return new Builder<E, S>(listFactory).setDefault();
        }
    }
}

